---
layout: default
title: ansible resource scans
nav_order: 1
---

# ansible resource scans (auto generated)

|     | Id             | Type     | Entity                                                                 | Policy                                                                                                                                                                             | IaC     | Resource Link                                                                                                                                                              |
|-----|----------------|----------|------------------------------------------------------------------------|------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|---------|----------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
|   0 | CKV_ANSIBLE_1  | resource | [?"ansible.builtin.uri" != null][]                                     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   1 | CKV_ANSIBLE_1  | resource | [?"uri" != null][]                                                     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   2 | CKV_ANSIBLE_1  | resource | [].block[?"ansible.builtin.uri" != null][]                             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   3 | CKV_ANSIBLE_1  | resource | [].block[?"uri" != null][]                                             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   4 | CKV_ANSIBLE_1  | resource | [].block[].block[?"ansible.builtin.uri" != null][]                     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   5 | CKV_ANSIBLE_1  | resource | [].block[].block[?"uri" != null][]                                     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   6 | CKV_ANSIBLE_1  | resource | [].block[].block[].block[?"ansible.builtin.uri" != null][]             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   7 | CKV_ANSIBLE_1  | resource | [].block[].block[].block[?"uri" != null][]                             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   8 | CKV_ANSIBLE_1  | resource | [].tasks[?"ansible.builtin.uri" != null][]                             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|   9 | CKV_ANSIBLE_1  | resource | [].tasks[?"uri" != null][]                                             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|  10 | CKV_ANSIBLE_1  | resource | [].tasks[].block[?"ansible.builtin.uri" != null][]                     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|  11 | CKV_ANSIBLE_1  | resource | [].tasks[].block[?"uri" != null][]                                     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|  12 | CKV_ANSIBLE_1  | resource | [].tasks[].block[].block[?"ansible.builtin.uri" != null][]             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|  13 | CKV_ANSIBLE_1  | resource | [].tasks[].block[].block[?"uri" != null][]                             | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|  14 | CKV_ANSIBLE_1  | resource | [].tasks[].block[].block[].block[?"ansible.builtin.uri" != null][]     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|  15 | CKV_ANSIBLE_1  | resource | [].tasks[].block[].block[].block[?"uri" != null][]                     | Ensure that certificate validation isn't disabled with uri                                                                                                                         | Ansible | [UriValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/UriValidateCerts.py)                                           |
|  16 | CKV_ANSIBLE_2  | resource | [?"ansible.builtin.get_url" != null][]                                 | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  17 | CKV_ANSIBLE_2  | resource | [?"get_url" != null][]                                                 | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  18 | CKV_ANSIBLE_2  | resource | [].block[?"ansible.builtin.get_url" != null][]                         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  19 | CKV_ANSIBLE_2  | resource | [].block[?"get_url" != null][]                                         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  20 | CKV_ANSIBLE_2  | resource | [].block[].block[?"ansible.builtin.get_url" != null][]                 | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  21 | CKV_ANSIBLE_2  | resource | [].block[].block[?"get_url" != null][]                                 | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  22 | CKV_ANSIBLE_2  | resource | [].block[].block[].block[?"ansible.builtin.get_url" != null][]         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  23 | CKV_ANSIBLE_2  | resource | [].block[].block[].block[?"get_url" != null][]                         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  24 | CKV_ANSIBLE_2  | resource | [].tasks[?"ansible.builtin.get_url" != null][]                         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  25 | CKV_ANSIBLE_2  | resource | [].tasks[?"get_url" != null][]                                         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  26 | CKV_ANSIBLE_2  | resource | [].tasks[].block[?"ansible.builtin.get_url" != null][]                 | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  27 | CKV_ANSIBLE_2  | resource | [].tasks[].block[?"get_url" != null][]                                 | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  28 | CKV_ANSIBLE_2  | resource | [].tasks[].block[].block[?"ansible.builtin.get_url" != null][]         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  29 | CKV_ANSIBLE_2  | resource | [].tasks[].block[].block[?"get_url" != null][]                         | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  30 | CKV_ANSIBLE_2  | resource | [].tasks[].block[].block[].block[?"ansible.builtin.get_url" != null][] | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  31 | CKV_ANSIBLE_2  | resource | [].tasks[].block[].block[].block[?"get_url" != null][]                 | Ensure that certificate validation isn't disabled with get_url                                                                                                                     | Ansible | [GetUrlValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/GetUrlValidateCerts.py)                                     |
|  32 | CKV_ANSIBLE_3  | resource | [?"ansible.builtin.yum" != null][]                                     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  33 | CKV_ANSIBLE_3  | resource | [?"yum" != null][]                                                     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  34 | CKV_ANSIBLE_3  | resource | [].block[?"ansible.builtin.yum" != null][]                             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  35 | CKV_ANSIBLE_3  | resource | [].block[?"yum" != null][]                                             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  36 | CKV_ANSIBLE_3  | resource | [].block[].block[?"ansible.builtin.yum" != null][]                     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  37 | CKV_ANSIBLE_3  | resource | [].block[].block[?"yum" != null][]                                     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  38 | CKV_ANSIBLE_3  | resource | [].block[].block[].block[?"ansible.builtin.yum" != null][]             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  39 | CKV_ANSIBLE_3  | resource | [].block[].block[].block[?"yum" != null][]                             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  40 | CKV_ANSIBLE_3  | resource | [].tasks[?"ansible.builtin.yum" != null][]                             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  41 | CKV_ANSIBLE_3  | resource | [].tasks[?"yum" != null][]                                             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  42 | CKV_ANSIBLE_3  | resource | [].tasks[].block[?"ansible.builtin.yum" != null][]                     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  43 | CKV_ANSIBLE_3  | resource | [].tasks[].block[?"yum" != null][]                                     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  44 | CKV_ANSIBLE_3  | resource | [].tasks[].block[].block[?"ansible.builtin.yum" != null][]             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  45 | CKV_ANSIBLE_3  | resource | [].tasks[].block[].block[?"yum" != null][]                             | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  46 | CKV_ANSIBLE_3  | resource | [].tasks[].block[].block[].block[?"ansible.builtin.yum" != null][]     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  47 | CKV_ANSIBLE_3  | resource | [].tasks[].block[].block[].block[?"yum" != null][]                     | Ensure that certificate validation isn't disabled with yum                                                                                                                         | Ansible | [YumValidateCerts.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumValidateCerts.py)                                           |
|  48 | CKV_ANSIBLE_4  | resource | [?"ansible.builtin.yum" != null][]                                     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  49 | CKV_ANSIBLE_4  | resource | [?"yum" != null][]                                                     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  50 | CKV_ANSIBLE_4  | resource | [].block[?"ansible.builtin.yum" != null][]                             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  51 | CKV_ANSIBLE_4  | resource | [].block[?"yum" != null][]                                             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  52 | CKV_ANSIBLE_4  | resource | [].block[].block[?"ansible.builtin.yum" != null][]                     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  53 | CKV_ANSIBLE_4  | resource | [].block[].block[?"yum" != null][]                                     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  54 | CKV_ANSIBLE_4  | resource | [].block[].block[].block[?"ansible.builtin.yum" != null][]             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  55 | CKV_ANSIBLE_4  | resource | [].block[].block[].block[?"yum" != null][]                             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  56 | CKV_ANSIBLE_4  | resource | [].tasks[?"ansible.builtin.yum" != null][]                             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  57 | CKV_ANSIBLE_4  | resource | [].tasks[?"yum" != null][]                                             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  58 | CKV_ANSIBLE_4  | resource | [].tasks[].block[?"ansible.builtin.yum" != null][]                     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  59 | CKV_ANSIBLE_4  | resource | [].tasks[].block[?"yum" != null][]                                     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  60 | CKV_ANSIBLE_4  | resource | [].tasks[].block[].block[?"ansible.builtin.yum" != null][]             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  61 | CKV_ANSIBLE_4  | resource | [].tasks[].block[].block[?"yum" != null][]                             | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  62 | CKV_ANSIBLE_4  | resource | [].tasks[].block[].block[].block[?"ansible.builtin.yum" != null][]     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  63 | CKV_ANSIBLE_4  | resource | [].tasks[].block[].block[].block[?"yum" != null][]                     | Ensure that SSL validation isn't disabled with yum                                                                                                                                 | Ansible | [YumSslVerify.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/YumSslVerify.py)                                                   |
|  64 | CKV_ANSIBLE_5  | resource | [?"ansible.builtin.apt" != null][]                                     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  65 | CKV_ANSIBLE_5  | resource | [?"apt" != null][]                                                     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  66 | CKV_ANSIBLE_5  | resource | [].block[?"ansible.builtin.apt" != null][]                             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  67 | CKV_ANSIBLE_5  | resource | [].block[?"apt" != null][]                                             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  68 | CKV_ANSIBLE_5  | resource | [].block[].block[?"ansible.builtin.apt" != null][]                     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  69 | CKV_ANSIBLE_5  | resource | [].block[].block[?"apt" != null][]                                     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  70 | CKV_ANSIBLE_5  | resource | [].block[].block[].block[?"ansible.builtin.apt" != null][]             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  71 | CKV_ANSIBLE_5  | resource | [].block[].block[].block[?"apt" != null][]                             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  72 | CKV_ANSIBLE_5  | resource | [].tasks[?"ansible.builtin.apt" != null][]                             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  73 | CKV_ANSIBLE_5  | resource | [].tasks[?"apt" != null][]                                             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  74 | CKV_ANSIBLE_5  | resource | [].tasks[].block[?"ansible.builtin.apt" != null][]                     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  75 | CKV_ANSIBLE_5  | resource | [].tasks[].block[?"apt" != null][]                                     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  76 | CKV_ANSIBLE_5  | resource | [].tasks[].block[].block[?"ansible.builtin.apt" != null][]             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  77 | CKV_ANSIBLE_5  | resource | [].tasks[].block[].block[?"apt" != null][]                             | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  78 | CKV_ANSIBLE_5  | resource | [].tasks[].block[].block[].block[?"ansible.builtin.apt" != null][]     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  79 | CKV_ANSIBLE_5  | resource | [].tasks[].block[].block[].block[?"apt" != null][]                     | Ensure that packages with untrusted or missing signatures are not used                                                                                                             | Ansible | [AptAllowUnauthenticated.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptAllowUnauthenticated.py)                             |
|  80 | CKV_ANSIBLE_6  | resource | [?"ansible.builtin.apt" != null][]                                     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  81 | CKV_ANSIBLE_6  | resource | [?"apt" != null][]                                                     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  82 | CKV_ANSIBLE_6  | resource | [].block[?"ansible.builtin.apt" != null][]                             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  83 | CKV_ANSIBLE_6  | resource | [].block[?"apt" != null][]                                             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  84 | CKV_ANSIBLE_6  | resource | [].block[].block[?"ansible.builtin.apt" != null][]                     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  85 | CKV_ANSIBLE_6  | resource | [].block[].block[?"apt" != null][]                                     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  86 | CKV_ANSIBLE_6  | resource | [].block[].block[].block[?"ansible.builtin.apt" != null][]             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  87 | CKV_ANSIBLE_6  | resource | [].block[].block[].block[?"apt" != null][]                             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  88 | CKV_ANSIBLE_6  | resource | [].tasks[?"ansible.builtin.apt" != null][]                             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  89 | CKV_ANSIBLE_6  | resource | [].tasks[?"apt" != null][]                                             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  90 | CKV_ANSIBLE_6  | resource | [].tasks[].block[?"ansible.builtin.apt" != null][]                     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  91 | CKV_ANSIBLE_6  | resource | [].tasks[].block[?"apt" != null][]                                     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  92 | CKV_ANSIBLE_6  | resource | [].tasks[].block[].block[?"ansible.builtin.apt" != null][]             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  93 | CKV_ANSIBLE_6  | resource | [].tasks[].block[].block[?"apt" != null][]                             | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  94 | CKV_ANSIBLE_6  | resource | [].tasks[].block[].block[].block[?"ansible.builtin.apt" != null][]     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  95 | CKV_ANSIBLE_6  | resource | [].tasks[].block[].block[].block[?"apt" != null][]                     | Ensure that the force parameter is not used, as it disables signature validation and allows packages to be downgraded which can leave the system in a broken or inconsistent state | Ansible | [AptForce.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/builtin/AptForce.py)                                                           |
|  96 | CKV2_ANSIBLE_1 | resource | tasks.ansible.builtin.uri                                              | Ensure that HTTPS url is used with uri                                                                                                                                             | Ansible | [UriHttpsOnly.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/UriHttpsOnly.yaml)                                               |
|  97 | CKV2_ANSIBLE_1 | resource | tasks.uri                                                              | Ensure that HTTPS url is used with uri                                                                                                                                             | Ansible | [UriHttpsOnly.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/UriHttpsOnly.yaml)                                               |
|  98 | CKV2_ANSIBLE_2 | resource | tasks.ansible.builtin.get_url                                          | Ensure that HTTPS url is used with get_url                                                                                                                                         | Ansible | [GetUrlHttpsOnly.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/GetUrlHttpsOnly.yaml)                                         |
|  99 | CKV2_ANSIBLE_2 | resource | tasks.get_url                                                          | Ensure that HTTPS url is used with get_url                                                                                                                                         | Ansible | [GetUrlHttpsOnly.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/GetUrlHttpsOnly.yaml)                                         |
| 100 | CKV2_ANSIBLE_3 | resource | block                                                                  | Ensure block is handling task errors properly                                                                                                                                      | Ansible | [BlockErrorHandling.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/BlockErrorHandling.yaml)                                   |
| 101 | CKV2_ANSIBLE_4 | resource | tasks.ansible.builtin.dnf                                              | Ensure that packages with untrusted or missing GPG signatures are not used by dnf                                                                                                  | Ansible | [DnfDisableGpgCheck.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/DnfDisableGpgCheck.yaml)                                   |
| 102 | CKV2_ANSIBLE_4 | resource | tasks.dnf                                                              | Ensure that packages with untrusted or missing GPG signatures are not used by dnf                                                                                                  | Ansible | [DnfDisableGpgCheck.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/DnfDisableGpgCheck.yaml)                                   |
| 103 | CKV2_ANSIBLE_5 | resource | tasks.ansible.builtin.dnf                                              | Ensure that SSL validation isn't disabled with dnf                                                                                                                                 | Ansible | [DnfSslVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/DnfSslVerify.yaml)                                               |
| 104 | CKV2_ANSIBLE_5 | resource | tasks.dnf                                                              | Ensure that SSL validation isn't disabled with dnf                                                                                                                                 | Ansible | [DnfSslVerify.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/DnfSslVerify.yaml)                                               |
| 105 | CKV2_ANSIBLE_6 | resource | tasks.ansible.builtin.dnf                                              | Ensure that certificate validation isn't disabled with dnf                                                                                                                         | Ansible | [DnfValidateCerts.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/DnfValidateCerts.yaml)                                       |
| 106 | CKV2_ANSIBLE_6 | resource | tasks.dnf                                                              | Ensure that certificate validation isn't disabled with dnf                                                                                                                         | Ansible | [DnfValidateCerts.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/DnfValidateCerts.yaml)                                       |
| 107 | CKV_AWS_88     | resource | [?"amazon.aws.ec2_instance" != null][]                                 | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 108 | CKV_AWS_88     | resource | [?"ec2_instance" != null][]                                            | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 109 | CKV_AWS_88     | resource | [].block[?"amazon.aws.ec2_instance" != null][]                         | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 110 | CKV_AWS_88     | resource | [].block[?"ec2_instance" != null][]                                    | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 111 | CKV_AWS_88     | resource | [].block[].block[?"amazon.aws.ec2_instance" != null][]                 | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 112 | CKV_AWS_88     | resource | [].block[].block[?"ec2_instance" != null][]                            | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 113 | CKV_AWS_88     | resource | [].block[].block[].block[?"amazon.aws.ec2_instance" != null][]         | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 114 | CKV_AWS_88     | resource | [].block[].block[].block[?"ec2_instance" != null][]                    | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 115 | CKV_AWS_88     | resource | [].tasks[?"amazon.aws.ec2_instance" != null][]                         | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 116 | CKV_AWS_88     | resource | [].tasks[?"ec2_instance" != null][]                                    | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 117 | CKV_AWS_88     | resource | [].tasks[].block[?"amazon.aws.ec2_instance" != null][]                 | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 118 | CKV_AWS_88     | resource | [].tasks[].block[?"ec2_instance" != null][]                            | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 119 | CKV_AWS_88     | resource | [].tasks[].block[].block[?"amazon.aws.ec2_instance" != null][]         | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 120 | CKV_AWS_88     | resource | [].tasks[].block[].block[?"ec2_instance" != null][]                    | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 121 | CKV_AWS_88     | resource | [].tasks[].block[].block[].block[?"amazon.aws.ec2_instance" != null][] | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 122 | CKV_AWS_88     | resource | [].tasks[].block[].block[].block[?"ec2_instance" != null][]            | EC2 instance should not have public IP.                                                                                                                                            | Ansible | [EC2PublicIP.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2PublicIP.py)                                                         |
| 123 | CKV_AWS_135    | resource | [?"amazon.aws.ec2_instance" != null][]                                 | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 124 | CKV_AWS_135    | resource | [?"ec2_instance" != null][]                                            | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 125 | CKV_AWS_135    | resource | [].block[?"amazon.aws.ec2_instance" != null][]                         | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 126 | CKV_AWS_135    | resource | [].block[?"ec2_instance" != null][]                                    | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 127 | CKV_AWS_135    | resource | [].block[].block[?"amazon.aws.ec2_instance" != null][]                 | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 128 | CKV_AWS_135    | resource | [].block[].block[?"ec2_instance" != null][]                            | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 129 | CKV_AWS_135    | resource | [].block[].block[].block[?"amazon.aws.ec2_instance" != null][]         | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 130 | CKV_AWS_135    | resource | [].block[].block[].block[?"ec2_instance" != null][]                    | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 131 | CKV_AWS_135    | resource | [].tasks[?"amazon.aws.ec2_instance" != null][]                         | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 132 | CKV_AWS_135    | resource | [].tasks[?"ec2_instance" != null][]                                    | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 133 | CKV_AWS_135    | resource | [].tasks[].block[?"amazon.aws.ec2_instance" != null][]                 | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 134 | CKV_AWS_135    | resource | [].tasks[].block[?"ec2_instance" != null][]                            | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 135 | CKV_AWS_135    | resource | [].tasks[].block[].block[?"amazon.aws.ec2_instance" != null][]         | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 136 | CKV_AWS_135    | resource | [].tasks[].block[].block[?"ec2_instance" != null][]                    | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 137 | CKV_AWS_135    | resource | [].tasks[].block[].block[].block[?"amazon.aws.ec2_instance" != null][] | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 138 | CKV_AWS_135    | resource | [].tasks[].block[].block[].block[?"ec2_instance" != null][]            | Ensure that EC2 is EBS optimized                                                                                                                                                   | Ansible | [EC2EBSOptimized.py](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/task/aws/EC2EBSOptimized.py)                                                 |
| 139 | CKV_PAN_2      | resource | tasks.paloaltonetworks.panos.panos_management_profile                  | Ensure plain-text management HTTP is not enabled for an Interface Management Profile                                                                                               | Ansible | [PanosInterfaceMgmtProfileNoHTTP.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosInterfaceMgmtProfileNoHTTP.yaml)         |
| 140 | CKV_PAN_3      | resource | tasks.paloaltonetworks.panos.panos_management_profile                  | Ensure plain-text management Telnet is not enabled for an Interface Management Profile                                                                                             | Ansible | [PanosInterfaceMgmtProfileNoTelnet.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosInterfaceMgmtProfileNoTelnet.yaml)     |
| 141 | CKV_PAN_4      | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure DSRI is not enabled within security policies                                                                                                                                | Ansible | [PanosPolicyNoDSRI.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyNoDSRI.yaml)                                     |
| 142 | CKV_PAN_5      | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure security rules do not have 'application' set to 'any'                                                                                                                       | Ansible | [PanosPolicyNoApplicationAny.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyNoApplicationAny.yaml)                 |
| 143 | CKV_PAN_6      | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure security rules do not have 'service' set to 'any'                                                                                                                           | Ansible | [PanosPolicyNoServiceAny.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyNoServiceAny.yaml)                         |
| 144 | CKV_PAN_7      | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure security rules do not have 'source_ip' and 'destination_ip' both containing values of 'any'                                                                                 | Ansible | [PanosPolicyNoSrcAnyDstAny.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyNoSrcAnyDstAny.yaml)                     |
| 145 | CKV_PAN_8      | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure description is populated within security policies                                                                                                                           | Ansible | [PanosPolicyDescription.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyDescription.yaml)                           |
| 146 | CKV_PAN_9      | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure a Log Forwarding Profile is selected for each security policy rule                                                                                                          | Ansible | [PanosPolicyLogForwarding.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyLogForwarding.yaml)                       |
| 147 | CKV_PAN_10     | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure logging at session end is enabled within security policies                                                                                                                  | Ansible | [PanosPolicyLoggingEnabled.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyLoggingEnabled.yaml)                     |
| 148 | CKV_PAN_12     | resource | tasks.paloaltonetworks.panos.panos_ipsec_profile                       | Ensure IPsec profiles do not specify use of insecure authentication algorithms                                                                                                     | Ansible | [PanosIPsecAuthenticationAlgorithms.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosIPsecAuthenticationAlgorithms.yaml)   |
| 149 | CKV_PAN_13     | resource | tasks.paloaltonetworks.panos.panos_ipsec_profile                       | Ensure IPsec profiles do not specify use of insecure protocols                                                                                                                     | Ansible | [PanosIPsecProtocols.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosIPsecProtocols.yaml)                                 |
| 150 | CKV_PAN_14     | resource | tasks.paloaltonetworks.panos.panos_zone                                | Ensure a Zone Protection Profile is defined within Security Zones                                                                                                                  | Ansible | [PanosZoneProtectionProfile.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosZoneProtectionProfile.yaml)                   |
| 151 | CKV_PAN_15     | resource | tasks.paloaltonetworks.panos.panos_zone                                | Ensure an Include ACL is defined for a Zone when User-ID is enabled                                                                                                                | Ansible | [PanosZoneUserIDIncludeACL.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosZoneUserIDIncludeACL.yaml)                     |
| 152 | CKV_PAN_16     | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure logging at session start is disabled within security policies except for troubleshooting and long lived GRE tunnels                                                         | Ansible | [PanosPolicyLogSessionStart.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyLogSessionStart.yaml)                   |
| 153 | CKV_PAN_17     | resource | tasks.paloaltonetworks.panos.panos_security_rule                       | Ensure security rules do not have 'source_zone' and 'destination_zone' both containing values of 'any'                                                                             | Ansible | [PanosPolicyNoSrcZoneAnyNoDstZoneAny.yaml](https://github.com/bridgecrewio/checkov/blob/main/checkov/ansible/checks/graph_checks/PanosPolicyNoSrcZoneAnyNoDstZoneAny.yaml) |


---


